#!/bin/sh

MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
MASTER_PAGE_MS_NETWORK_CONF_RESULT_OK=0
MASTER_PAGE_MS_NETWORK_CONF_RESULT_ERROR=1

MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=${MASTER_PAGE_MS_NETWORK_CONF_RESULT_ERROR}
MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0

MASTER_PAGE_MS_NETWORK_USER_INPUT_IP=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""
    
MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_GATEWAY=""

MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS2=""
MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS3=""

master_page_ms_network_conf() {
    #dprint 0 "debug" "Enter master_page_ms_network_conf ${conf_ms_ip} ${conf_ms_netmask} ${conf_ms_gateway} ${conf_ms_dns} ${conf_ms_dns2} ${conf_ms_ipv6} ${conf_ms_ipv6_prefix_length} ${conf_ms_ipv6_gateway} ${conf_ms_ipv6_dns} ${conf_ms_ipv6_dns2}"

    # assign default value
    dprint "DEBUG" "===== Configure appliance default connection IP address ====="
    CURRENT_IP=`ip -f inet -o addr show eth0 | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g'`
    [ -z "${RT_MS_IP}" ] && RT_MS_IP="${CURRENT_IP}"

    CURRENT_MASK=`/sbin/ifconfig eth0 | sed -n 's/.*inet.*netmask \([0-9\.]*\).*/\1/p' 2>&1`
    [ -z "${RT_MS_NETMASK}" ] && RT_MS_NETMASK="${CURRENT_MASK}"
    
    CURRENT_GATEWAY=`/sbin/ip route | awk '/default/ {print $3}' 2>&1`
    [ -z "${RT_MS_GATEWAY}" ] && RT_MS_GATEWAY="${CURRENT_GATEWAY}"

    CURRENT_IPV6=`ip -f inet6 -o addr show eth0 | grep -v 'local' | grep -v 'dynamic' | sed -n '1p' | awk '{print $4}' | sed 's/\/.*$//g' | tr '[a-z]' '[A-Z]'`
    local upcase=`echo ${CURRENT_IPV6:0:5} | tr '[a-z]' '[A-Z]'`
    if [ "${upcase}" = "FE80:" ]; then
        CURRENT_IPV6=""
    fi

    [ -z "${RT_MS_IPV6}" ]      && RT_MS_IPV6="${CURRENT_IPV6}"

    CURRENT_IPV6_PREFIX=""
    if [ "${CURRENT_IPV6}" != "" ]; then
        CURRENT_IPV6_PREFIX=`/sbin/ifconfig eth0 | grep 'inet6 ' | grep '<global>' | sed -n 's/.*prefixlen \([0-9\.]*\).*/\1/p' 2>&1`
    fi
    [ -z "${RT_MS_IPV6_PREFIX_LENGTH}" ] && RT_MS_IPV6_PREFIX_LENGTH="${CURRENT_IPV6_PREFIX}"

    CURRENT_IPV6_GATEWAY=`/sbin/ip -6 route | grep -v 'kernel' | awk '/default/ {print $3}' | tr '[a-z]' '[A-Z]' | head -n 1 2>&1`
    upcase=`echo ${CURRENT_IPV6_GATEWAY:0:5} | tr '[a-z]' '[A-Z]'`
    if [ "${upcase}" = "FE80:" ]; then
        CURRENT_IPV6_GATEWAY=""
    fi
    [ -z "${RT_MS_IPV6_GATEWAY}" ] && RT_MS_IPV6_GATEWAY="${CURRENT_IPV6_GATEWAY}"
    
    CURRENT_DNS1=`/bin/sed -e '/^$/d' /etc/resolv.conf | grep -v "^#" | grep "^nameserver" | grep -m 3 -i nameserver | awk '{print $2}' | sed -n '1p' 2>&1`
    CURRENT_DNS2=`/bin/sed -e '/^$/d' /etc/resolv.conf | grep -v "^#" | grep "^nameserver" | grep -m 3 -i nameserver | awk '{print $2}' | sed -n '2,2p' 2>&1`  
    CURRENT_DNS3=`/bin/sed -e '/^$/d' /etc/resolv.conf | grep -v "^#" | grep "^nameserver" | grep -m 3 -i nameserver | awk '{print $2}' | sed -n '3,3p' 2>&1`
    [ -z "${RT_MS_DNS}" ]     && RT_MS_DNS="${CURRENT_DNS1}"
    [ -z "${RT_MS_DNS2}" ]     && RT_MS_DNS2="${CURRENT_DNS2}"
    [ -z "${RT_MS_DNS3}" ]     && RT_MS_DNS3="${CURRENT_DNS3}"

	tp_network_conf \
		"${MASTER_PAGE_MS_NETWORK_CONF_TITLE}" \
		"${MASTER_PAGE_MS_NETWORK_CONF_TEXT}" \
		"${MASTER_PAGE_MS_NETWORK_CONF_LABEL_OK}" \
		"${MASTER_PAGE_MS_NETWORK_CONF_LABEL_CANCEL}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_IP:-$RT_MS_IP}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_NETMASK:-$RT_MS_NETMASK}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_GATEWAY:-$RT_MS_GATEWAY}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6:-$RT_MS_IPV6}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH:-$RT_MS_IPV6_PREFIX_LENGTH}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_GATEWAY:-$RT_MS_IPV6_GATEWAY}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS:-$RT_MS_DNS}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS2:-$RT_MS_DNS2}" \
        "${MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS3:-$RT_MS_DNS3}"

    #debug_print "${0}" "${LINENO}" "TP_NETWORK_CONF_RESULT_CODE: ${TP_NETWORK_CONF_RESULT_CODE}"
    dprint "DEBUG" "tp_network_conf result:${TP_NETWORK_CONF_RESULT_CODE}"
    case "${TP_NETWORK_CONF_RESULT_CODE}" in
    
        "${TP_NETWORK_CONF_RESULT_ERROR}")
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_MS_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_RESULT_MSG}"

            RT_MS_IP="${TP_NETWORK_CONF_RESULT_IP}"
            RT_MS_NETMASK="${TP_NETWORK_CONF_RESULT_NETMASK}"
            RT_MS_GATEWAY="${TP_NETWORK_CONF_RESULT_GATEWAY}"
            RT_MS_DNS="${TP_NETWORK_CONF_RESULT_DNS}"
            RT_MS_DNS2="${TP_NETWORK_CONF_RESULT_DNS2}"
            RT_MS_IPV6="${TP_NETWORK_CONF_RESULT_IPV6}"
            RT_MS_IPV6_PREFIX_LENGTH="${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}"
            RT_MS_IPV6_GATEWAY="${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}"
            RT_MS_DNS="${TP_NETWORK_CONF_RESULT_DNS}"
            RT_MS_DNS2="${TP_NETWORK_CONF_RESULT_DNS2}"
            RT_MS_DNS3="${TP_NETWORK_CONF_RESULT_DNS3}"

            return
            ;;
        
        "${TP_NETWORK_CONF_RESULT_CANCEL}")
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_MS_NETWORK_CONF_RESULT_OK
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
            
            MASTER_PAGE_MS_NETWORK_USER_INPUT_IP=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_GATEWAY=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS2=""
            MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS3=""

            RT_MS_IP=""
            RT_MS_NETMASK=""
            RT_MS_GATEWAY=""
            RT_MS_IPV6=""
            RT_MS_IPV6_PREFIX_LENGTH=""
            RT_MS_IPV6_GATEWAY=""
            RT_MS_DNS=""
            RT_MS_DNS2=""
            RT_MS_DNS3=""
            
            return
            ;;
            
        "${TP_NETWORK_CONF_RESULT_OK}" )
            RT_MS_IP=""
            RT_MS_NETMASK=""
            RT_MS_GATEWAY=""
            RT_MS_IPV6=""
            RT_MS_IPV6_PREFIX_LENGTH=""
            RT_MS_IPV6_GATEWAY=""
            RT_MS_DNS=""
            RT_MS_DNS2=""
            RT_MS_DNS3=""
            ;;
        
        *)
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_MS_NETWORK_CONF_RESULT_ERROR
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0
            MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_MS_NETWORK_CONF_ERROR_UNKNOWN}"

            RT_MS_IP=""
            RT_MS_NETMASK=""
            RT_MS_GATEWAY=""
            RT_MS_IPV6=""
            RT_MS_IPV6_PREFIX_LENGTH=""
            RT_MS_IPV6_GATEWAY=""
            RT_MS_DNS=""
            RT_MS_DNS2=""
            RT_MS_DNS3=""
            return
            ;;
    esac

    # apply and error handling

#	if [ "${TP_NETWORK_CONF_RESULT_DNS2}" == "..." ]; then
#        TP_NETWORK_CONF_RESULT_DNS2=""
#    fi

	dialog \
		--title     "Message" \
		--backtitle "${CONS_BACK_TITLE}" \
		--msgbox    "${TP_NETWORK_CONF_MSG_WAIT}" \
		            "${CONS_BOX_HEIGHT}" \
					"${CONS_BOX_ERROR_WIDTH}"

    local hostname="" # Because there is no hostname input field in Text UI. Assign it to empty string for later module to keep hostname unchanged
    local RET_MSG=`/opt/TrendMicro/Pixiebob/textUI/network_settings_hostname_ip.sh "set" "${hostname}" \
            "${TP_NETWORK_CONF_RESULT_IP}" "${TP_NETWORK_CONF_RESULT_NETMASK}" \
            "${TP_NETWORK_CONF_RESULT_GATEWAY}" \
            "${TP_NETWORK_CONF_RESULT_IPV6}" "${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}" \
            "${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}" "${TP_NETWORK_CONF_RESULT_DNS}" \
            "${TP_NETWORK_CONF_RESULT_DNS2}" "${TP_NETWORK_CONF_RESULT_DNS3}" \
            "from_text_ui" "eth0" 2>/dev/null`

    dprint "DEBUG" "Return message:${RET_MSG}"
    local ERR_CODE=`echo "$RET_MSG" | grep err_code | sed -e 's/^\"err_code\"\ :\ \"//g' | sed -e 's/\",$//g'`
    #dprint 0 "debug" "ERR_CODE = $ERR_CODE"

   # /opt/TrendMicro/DTAS/ManagementServer/bin/lock /opt/TrendMicro/locks/system_network_setting.lock R WAIT echo

    if [ "$ERR_CODE" == "" ]; then
        # apply successfully
        CONS_BACK_TITLE="Trend Micro Deep Discovery Director $(cat /opt/TrendMicro/Pixiebob/version.txt)"
        IPV4_ADDR=${TP_NETWORK_CONF_RESULT_IP}
        IPV6_ADDR=${TP_NETWORK_CONF_RESULT_IPV6}
        [ "${IPV4_ADDR}" = "" ] && IPV4_ADDR="-"
        [ "${IPV6_ADDR}" = "" ] && IPV6_ADDR="-"
        CONS_IP_ADDR="(IPv4: ${IPV4_ADDR} | IPv6: ${IPV6_ADDR})"
        CONS_IP_ADDR_V4="IPv4: ${IPV4_ADDR}"
        CONS_IP_ADDR_V6="IPv6: ${IPV6_ADDR}"
        conf_ms_ip=${TP_NETWORK_CONF_RESULT_IP}
        conf_ms_netmask=${TP_NETWORK_CONF_RESULT_NETMASK}
        conf_ms_gateway=${TP_NETWORK_CONF_RESULT_GATEWAY}
        conf_ms_ipv6=${TP_NETWORK_CONF_RESULT_IPV6}
        conf_ms_ipv6_prefix_length=${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}
        conf_ms_ipv6_gateway=${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}
        conf_ms_dns=${TP_NETWORK_CONF_RESULT_DNS}
        conf_ms_dns2=${TP_NETWORK_CONF_RESULT_DNS2}
        conf_ms_dns3=${TP_NETWORK_CONF_RESULT_DNS3}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IP=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_NETMASK=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_GATEWAY=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS2=""
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS3=""

        MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_MS_NETWORK_CONF_RESULT_OK
        MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=1
        MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG=""
        dprint "DEBUG" "===== Finish Configure appliance default connection IP address ====="
    else
        # invalid input or system locked
        local ERR_MSG=`echo "$RET_MSG" | grep err_message | sed -e 's/^\"err_message\"\ :\ \"//g' | sed -e 's/\"$//g'`
        dprint "ERROR" "Error message:${ERR_MSG}"
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IP=${TP_NETWORK_CONF_RESULT_IP}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_NETMASK=${TP_NETWORK_CONF_RESULT_NETMASK}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_GATEWAY=${TP_NETWORK_CONF_RESULT_GATEWAY}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6=${TP_NETWORK_CONF_RESULT_IPV6}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_PREFIX_LENGTH=${TP_NETWORK_CONF_RESULT_IPV6_PREFIX_LENGTH}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_IPV6_GATEWAY=${TP_NETWORK_CONF_RESULT_IPV6_GATEWAY}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS=${TP_NETWORK_CONF_RESULT_DNS}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS2=${TP_NETWORK_CONF_RESULT_DNS2}
        MASTER_PAGE_MS_NETWORK_USER_INPUT_DNS3=${TP_NETWORK_CONF_RESULT_DNS3}

        MASTER_PAGE_MS_NETWORK_CONF_RESULT_CODE=$MASTER_PAGE_MS_NETWORK_CONF_RESULT_ERROR
        MASTER_PAGE_MS_NETWORK_CONF_RESULT_ROLLING=0

        #dprint 0 "debug" "ERR_CODE = $ERR_CODE"

        case "${ERR_CODE}" in
        
            "2")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IP}"
                return
                ;;
            "3")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_NETMASK}"
                return
                ;;
            "4")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_GATEWAY}"
                return
                ;;
            "5")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS}"
                return
                ;;
            "6")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS2}"
                return
                ;;
            "7")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_SYSTEM_LOCKED}"
                return
                ;;
            "8")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${ERR_MSG}"
                return
                ;;
            "9")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_EMPTY_IP_AND_IPV6}"
                return
                ;;
            "10")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6}"
                return
                ;;
            "11")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_PREFIX_LENGTH}"
                return
                ;;
            "12")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_GATEWAY}"
                return
                ;;
            "13")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_DNS3}"
                return
                ;;
            "17")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IPV4_ADDRESS_CONFLICT} ${TP_NETWORK_CONF_RESULT_IP}."
                return
                ;;
            "18")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_IPV6_ADDRESS_CONFLICT} ${TP_NETWORK_CONF_RESULT_IPV6}."
                return
                ;;
            "21")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV4_4_VIP}"
                return
                ;;
            "22")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_4_VIP}"
                return
                ;;
            "23")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_NULL}"
                return
                ;;
            "24")
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${TP_NETWORK_CONF_ERROR_INVALID_IPV6_CHANGE}"
                return
                ;;
            *)
                MASTER_PAGE_MS_NETWORK_CONF_RESULT_MSG="${MASTER_PAGE_MS_NETWORK_CONF_ERROR_UNKNOWN}"
                return
                ;;
        esac        
    fi
}
